﻿/*
VERSION:		1.5

DESCRIPTION:
	This function makes it easy to create a window.
	
USAGE:
	makeWindow( winContent, [winTitle, hasCloseBtn, passedData] );
	makeWindow( "my_mc", "My window", true, {showText:"Passed data", myVar:42} );
	
NOTE:
	Your content's  onClose()  function will be called when the window is closed.
*/



/*	Class Dependancies:

nextDepth.as

*/



_global.makeWindow = function( winContent, winTitle, hasCloseBtn, passedData )
{
	// Optional parameters
	winTitle = (winTitle) ? winTitle : "";		// default = ""
	hasCloseBtn = (hasCloseBtn == undefined) ? true : hasCloseBtn;					// default = true;
	passedData = (passedData) ? passedData : new Object();		// 
	
	
	
	// Darken the background
	#include "nextDepth.as"
	var screenShader_mc = _root.createEmptyMovieClip("darkenScreen_mc", nextDepth(_parent) );
	screenShader_mc.beginFill(0x000000, 50);
	screenShader_mc.moveTo(0, 0);
	screenShader_mc.lineTo(Stage.width, 0);		// right
	screenShader_mc.lineTo(Stage.width, Stage.height);		// down
	screenShader_mc.lineTo(0, Stage.height);		// left
	screenShader_mc.lineTo(0, 0);		// up
	screenShader_mc.endFill();
	
	
	
	
	// Make a Window
	var windowSettings = new Object();
	windowSettings.closeButton = hasCloseBtn;
	windowSettings.contentPath = winContent;
	windowSettings.title = winTitle;
	windowSettings.data = passedData;		// readable by the movieClip inside the window
	var my_win = mx.managers.PopUpManager.createPopUp(_root, mx.containers.Window, true, windowSettings);
	
	
	
	// Resize the window
	my_win.loaded = new Object();
	my_win.addEventListener("complete", my_win.loaded);
	my_win.loaded.complete = function()
	{
		// Resize to content
		var xPadding = 6;
		var yPadding = 34;
		var mc_width = my_win.content._width  +  xPadding;
		var mc_height = my_win.content._height  +  yPadding;
		my_win.setSize(mc_width, mc_height);
		
		// Center the window
		var screenWidth = Stage.width;
		var screenHeight = Stage.height;
		var newX = (screenWidth / 2) - (mc_width / 2);
		var newY = (screenHeight / 2) - (mc_height / 2);
		my_win.move(newX, newY, false);
		
	}// loaded.complete()
	
	
	
	// Remove the window
	my_win.close = function()
	{
		my_win.content.onClose();
		screenShader_mc.removeMovieClip();
		my_win.onClose( my_win.content.output );		// externally-defined funtion
		my_win.deletePopUp();
	}// close()
	
	
	
	// Close button
	my_win.addEventListener("click", my_win);
	my_win.click = function()
	{
		my_win.close();
	}// click()
	
	
	
	// Copy passed data into the movieClip
	my_win.addEventListener("complete", my_win);
	my_win.complete = function()
	{
		for (var nam in my_win.data)
		{
			my_win.content[nam] = my_win.data[nam];
		}// for...in
	}// onLoad()
	
	return my_win;
}// makeWindow()